import 'package:admin_desktop/infrastructure/services/app_helpers.dart';
import 'package:admin_desktop/infrastructure/services/tr_keys.dart';
import 'package:admin_desktop/presentation/styles/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';

class SearchFormField extends StatelessWidget {
  final TextEditingController? controller;
  final ValueChanged onChanged;

  const SearchFormField(
      {super.key, required this.controller, required this.onChanged});

  @override
  Widget build(BuildContext context) {
    return Expanded(
      child: TextFormField(
        controller: controller,
        style: GoogleFonts.inter(
          fontWeight: FontWeight.w400,
          fontSize: 14.sp,
          color: Style.black,
          letterSpacing: -0.5,
        ),
        onChanged: onChanged,
        cursorWidth: 1.r,
        cursorColor: Style.black,
        decoration: InputDecoration.collapsed(
          hintText: AppHelpers.getTranslation(TrKeys.searchLocation),
          hintStyle: GoogleFonts.inter(
            fontWeight: FontWeight.w400,
            fontSize: 14.sp,
            color: Style.iconButtonBack,
            letterSpacing: -0.5,
          ),
        ),
      ),
    );
  }
}
